# As postagens mais acessadas por Léo Vilhena

**Versão:** 2.0.1 (Otimizada)  
**Autor:** Léo Vilhena  
**Requer WordPress:** 5.0 ou superior  
**Testado até:** 6.4  
**Licença:** GPL v2 ou posterior

## 📊 Descrição

Plugin otimizado para exibir as postagens mais acessadas do seu site WordPress com sistema de cache avançado e rastreamento eficiente.

## ⏰ PADRÃO: ÚLTIMAS 24 HORAS

Por padrão, o plugin exibe os posts **mais acessados das últimas 24 horas**. Você pode alterar isso nas configurações para:
- Últimas 24 horas (PADRÃO)
- Últimos 7 dias
- Últimos 30 dias
- Todos os tempos

## ✨ Novidades da Versão 2.0.1

### 🔄 Alterações
- ✅ Período padrão alterado para "Últimas 24 horas"
- ✅ Melhor para sites de notícias e conteúdo dinâmico
- ✅ Mantém todas as otimizações de performance

### 🚀 Performance Melhorada
- ✅ Sistema de cache completo (reduz 90% das queries)
- ✅ Rastreamento via AJAX assíncrono (não bloqueia página)
- ✅ Carregamento lazy das imagens
- ✅ CSS condicional (só carrega quando necessário)
- ✅ Código 100% encapsulado (zero conflitos)

### 🔧 Melhorias Técnicas
- Singleton pattern para evitar múltiplas instâncias
- Queries otimizadas com `no_found_rows`
- Cache configurável (1 min a 1 hora)
- Namespace isolado
- Meta keys únicos (v2)

## 📦 Instalação

1. Faça upload da pasta `leovilhena-posts-otimizado` para `/wp-content/plugins/`
2. Ative o plugin através do menu 'Plugins' no WordPress
3. Configure em `Configurações > LeoVilhena Posts`

## 🎯 Como Usar

### Shortcode
```php
[leovilhena_posts]
```

### Com Opções
```php
[leovilhena_posts limit="5" title="Mais Lidos nas Últimas 24h" layout="grid"]
```

### No Template PHP
```php
<?php echo do_shortcode('[leovilhena_posts]'); ?>
```

### Widget
Vá em **Aparência > Widgets** e adicione o widget "LeoVilhena Posts (Otimizado)"

## ⚙️ Opções do Shortcode

| Parâmetro | Descrição | Padrão |
|-----------|-----------|--------|
| `limit` | Número de posts | 3 |
| `title` | Título do widget | "Posts Mais Acessados" |
| `layout` | Layout (list/grid) | list |
| `category` | ID da categoria | null |

## 🎨 Layouts Disponíveis

- **list**: Lista vertical com thumbnails
- **grid**: Grade responsiva com cards

## 📈 Painel de Estatísticas

Acesse **Top Posts** no menu do WordPress para ver:
- Total de visualizações
- Ranking completo dos posts
- Gráficos e estatísticas

## ⚡ Configurações de Performance

### Tempo de Cache
- 1 minuto (sites em desenvolvimento)
- **5 minutos (Recomendado)**
- 10 minutos
- 30 minutos
- 1 hora (sites estáticos)

### Período de Posts
- **Últimas 24 horas (PADRÃO)**
- Últimos 7 dias
- Últimos 30 dias
- Todos os tempos

## 💡 Ideal Para:

✅ Sites de notícias  
✅ Blogs com conteúdo dinâmico  
✅ Portais que publicam diariamente  
✅ Sites que querem destacar conteúdo recente  

## 🔒 Privacidade

- Não rastreia administradores (configurável)
- Não armazena IPs ou dados pessoais
- 100% LGPD/GDPR compliant

## 🆘 Suporte

Para dúvidas ou problemas:
- Site: https://designer.redegni.com.br
- Email: [email protected]

## 📝 Changelog

### 2.0.1 (2024)
- Período padrão alterado para "Últimas 24 horas"
- Descrição do plugin atualizada

### 2.0.0 (2024)
- Sistema de cache completo
- AJAX otimizado com requestIdleCallback
- Código 100% encapsulado
- Lazy loading de imagens
- Queries otimizadas
- CSS condicional

### 1.0.0
- Versão inicial

## 👨‍💻 Autor

**Léo Vilhena**  
Designer & Desenvolvedor WordPress  
https://designer.redegni.com.br

---

⭐ Se você gostou deste plugin, deixe uma avaliação!
